<?php

// CONFIGURATIONS

$colors = array(
	'bg' => '#cccccc' ,
	'main' => '#ffffff' ,
	'main_rev' => '#666666' ,
	'header' => '#2f5376' ,
	'header_rev' => '#ffffff' ,
	'link' => '#666666' ,
	'link_hover' => '#ff6600' ,
	'impact' => '#2f5376' ,
	'impact_rev' => '#ffffff' ,
	'title' => '#dddddd' ,
	'title_rev' => '#639ace' ,
	'head' => '#c2cdd6' ,
	'even' => '#dee3e7' ,
	'odd' => '#e9e9e9' ,
	'error' => '#ffcccc' ,
	'confirm' => '#ddffdd' ,
	'result' => '#dddddd' ,
	'border' => '#999999' ,
) ;
$fonts = array(
	'main' => '"Verdana","Arial","Helvetica","sans-serif"' ,
	'monospace' => '"Courier New","Courier","monospace"' ,
) ;
$sizes = array(
	'body_min_width' => 750 ,
	'body_max_width' => 1024 ,
	'block_left_width' => 170 ,
	'block_right_width' => 170 ,
	'header_height' => 80 ,
	'footer_height' => 23 ,
) ;
$cache_limit = 3600 ; // 1 hour

// END OF CONFIGURATIONS


include '../../mainfile.php' ;

// theme name
// $theme = $xoopsConfig['theme_set']
$theme = basename( dirname(__FILE__) ) ;
$template = preg_replace( '/[^0-9a-zA-Z_.-]/' , '' , @$_GET['template'] ) ;
if( empty( $template ) ) $template = 'screen.css' ;

// UA
if( stristr( $_SERVER['HTTP_USER_AGENT'] , 'Opera' ) ) {
	$ua_type = 'Opera' ;
} else if( stristr( $_SERVER['HTTP_USER_AGENT'] , 'MSIE' ) ) {
	$ua_type = 'IE' ;
} else {
	$ua_type = 'NN' ;
}

// send header
if( ! headers_sent() ) {
	session_cache_limiter('public');
	header("Expires: ".date('r',intval(time()/$cache_limit)*$cache_limit+$cache_limit));
	header("Cache-Control: public, max-age=$cache_limit");
	header("Last-Modified: ".date('r',intval(time()/$cache_limit)*$cache_limit));
	header('Content-Type: text/css') ;
}

if( is_object( $xoopsUser ) ) {
	$xoops_isuser = true ;
	$xoops_userid = $xoopsUser->getVar('uid') ;
	$xoops_uname = $xoopsUser->getVar('uname') ;
	$xoops_isadmin = $xoopsUserIsAdmin ;
} else {
	$xoops_isuser = false ;
	$xoops_userid = 0 ;
	$xoops_uname = '' ;
	$xoops_isadmin = false ;
}


require_once XOOPS_ROOT_PATH.'/class/template.php' ;
$tpl =& new XoopsTpl() ;
$tpl->assign( array(
	'xoops_config' => $xoopsConfig ,
	'xoops_theme' => $theme ,
	'xoops_imageurl' => XOOPS_THEME_URL.'/'.$theme.'/' ,
	'xoops_themecss' => xoops_getcss($theme) ,
	'xoops_isuser' => $xoops_isuser ,
	'xoops_userid' => $xoops_userid ,
	'xoops_uname' => $xoops_uname ,
	'xoops_isadmin' => $xoops_isadmin ,
	'color' => $colors ,
	'font' => $fonts ,
	'size' => $sizes ,
	'ua_type' => $ua_type ,
) ) ;
$tpl->display( dirname(__FILE__).'/'.$template ) ;
exit ;

?>