<?php

class Protector {

var $message = '' ;
var $warning = false ;
var $error = false ;
var $_doubtful_requests = array() ;

// var $_accessfile ;

var $_logged = false ;

var $_done_badext = false ;
var $_done_intval = false ;
var $_done_dotdot = false ;
var $_done_contami = false ;
var $_done_isocom = false ;
var $_done_union = false ;
var $_done_dos = false ;

var $_safe_badext = true ;
var $_safe_contami = true ;
var $_safe_isocom = true ;
var $_safe_union = true ;

var $_should_be_banned = false ;

var $_dos_stage = null ;

var $last_error_type = 'UNKNOWN' ;


// Constructor
function Protector()
{
	$this->pickup_doubtful_recursive( $_GET , 'G' ) ;
	$this->pickup_doubtful_recursive( $_POST , 'P' ) ;
	$this->pickup_doubtful_recursive( $_COOKIE , 'C' ) ;

	// $cache_dir = defined( 'XOOPS_CACHE_PATH' ) ? XOOPS_CACHE_PATH : XOOPS_ROOT_PATH."/cache" ;
	// $this->_accessfile = $cache_dir . '/protector_access_' . substr( md5( XOOPS_ROOT_PATH ) , -10 ) ;
}


function pickup_doubtful_recursive( $val , $key )
{
	if( is_array( $val ) ) {
		foreach( $val as $subkey => $subval ) {
			$this->pickup_doubtful_recursive( $subval , $key . '_' . base64_encode( $subkey ) ) ;
		}
	} else {
		if( preg_match( '?[\s\'"`/]?' , $val ) ) {
			$this->_doubtful_requests["$key"] = $val ;
		}
	}
}


function &getInstance()
{
	static $instance ;
	if( ! isset( $instance ) ) {
		$instance = new Protector() ;
	}
	return $instance;
}


function purge()
{
	// clear all session values
	if( isset( $_SESSION ) ) foreach( $_SESSION as $key => $val ) {
		$_SESSION[ $key ] = '' ;
		if( isset( $GLOBALS[ $key ] ) ) $GLOBALS[ $key ] = '' ;
	}

	if( ! headers_sent() ) {
		// clear typical session id of PHP
		setcookie('PHPSESSID', '', time() - 3600, '/', '', 0);

		// clear autologin cookie
		$xoops_cookie_path = defined('XOOPS_COOKIE_PATH') ? XOOPS_COOKIE_PATH : preg_replace( '?http://[^/]+(/.*)$?' , "$1" , XOOPS_URL ) ;
		if( $xoops_cookie_path == XOOPS_URL ) $xoops_cookie_path = '/' ;
		setcookie('autologin_uname', '', time() - 3600, $xoops_cookie_path, '', 0);
		setcookie('autologin_pass', '', time() - 3600, $xoops_cookie_path, '', 0);
	}

	exit ;
}


function output_log( $type = 'UNKNOWN' , $uid = 0 , $unique_check = false )
{
	if( $this->_logged ) return true ;

	$ip = $_SERVER['REMOTE_ADDR'] ;
	$agent = $_SERVER['HTTP_USER_AGENT'] ;

	$db = Database::getInstance() ;

	if( $unique_check ) {
		$result = $db->query( "SELECT ip,type FROM ".$db->prefix("protector_log")." ORDER BY timestamp DESC LIMIT 1" ) ;
		list( $last_ip , $last_type ) = $db->fetchRow( $result ) ;
		if( $last_ip == $ip && $last_type == $type ) {
			$this->_logged = true ;
			return true ;
		}
	}

	$db->queryF( "INSERT INTO ".$db->prefix("protector_log")." SET ip='".addslashes($ip)."',agent='".addslashes($agent)."',type='".addslashes($type)."',description='".addslashes($this->message)."',uid='".intval($uid)."'" ) ;
	$this->_logged = true ;
	return true ;
}


function output_log_prepare( $type = 'UNKNOWN' , $conn = null , $unique_check = false )
{
	$ip = $_SERVER['REMOTE_ADDR'] ;
	$agent = $_SERVER['HTTP_USER_AGENT'] ;
	if( empty( $conn ) ) return false ;

	if( $unique_check ) {
		$result = mysql_query( "SELECT ip,type FROM ".XOOPS_DB_PREFIX."_protector_log ORDER BY timestamp DESC LIMIT 1" , $conn ) ;
		list( $last_ip , $last_type ) = mysql_fetch_row( $result ) ;
		if( $last_ip == $ip && $last_type == $type ) {
			$this->_logged = true ;
			return true ;
		}
	}

	mysql_query( "INSERT INTO ".XOOPS_DB_PREFIX."_protector_log SET ip='".addslashes($ip)."',agent='".addslashes($agent)."',type='".addslashes($type)."',description='".addslashes($this->message)."',uid=0" , $conn ) ;
	$this->_logged = true ;
	return true ;
}


function register_bad_ips( $ip = null )
{
	if( empty( $ip ) ) $ip = $_SERVER['REMOTE_ADDR'] ;
	if( empty( $ip ) ) return false ;

	$db = Database::getInstance() ;
	$rs = $db->query( "SELECT conf_value FROM ".$db->prefix("config")." WHERE conf_name='bad_ips' AND conf_modid=0 AND conf_catid=1" ) ;
	list( $bad_ips_serialized ) = $db->fetchRow( $rs ) ;
	$bad_ips = unserialize( $bad_ips_serialized ) ;
	$bad_ips[] = $ip ;

	$conf_value = addslashes( serialize( array_unique( $bad_ips ) ) ) ;
	$db->queryF( "UPDATE ".$db->prefix("config")." SET conf_value='$conf_value' WHERE conf_name='bad_ips' AND conf_modid=0 AND conf_catid=1" ) ;

	return true ;
}


function intval_allrequestsendid()
{
	global $HTTP_GET_VARS , $HTTP_POST_VARS , $HTTP_COOKIE_VARS ;

	if( $this->_done_intval ) return true ;
	else $this->_done_intval = true ;

	foreach( $_GET as $key => $val ) {
		if( substr( $key , -2 ) == 'id' && ! is_array( $_GET[ $key ] ) ) {
			$_GET[ $key ] = $HTTP_GET_VARS[ $key ] = intval( $val ) ;
			if( $_REQUEST[ $key ] == $_GET[ $key ] ){
				$_REQUEST[ $key ] = intval( $val ) ;
			}
		}
	}
	foreach( $_POST as $key => $val ) {
		if( substr( $key , -2 ) == 'id' && ! is_array( $_POST[ $key ] ) ) {
			$_POST[ $key ] = $HTTP_POST_VARS[ $key ] = intval( $val ) ;
			if( $_REQUEST[ $key ] == $_POST[ $key ] ){
				$_REQUEST[ $key ] = intval( $val ) ;
			}
		}
	}
	foreach( $_COOKIE as $key => $val ) {
		if( substr( $key , -2 ) == 'id' && ! is_array( $_COOKIE[ $key ] ) ) {
			$_COOKIE[ $key ] = $HTTP_COOKIE_VARS[ $key ] = intval( $val ) ;
			if( $_REQUEST[ $key ] == $_COOKIE[ $key ] ){
				$_REQUEST[ $key ] = intval( $val ) ;
			}
		}
	}

	return true ;
}


function eliminate_dotdot( $conn = null )
{
	global $HTTP_GET_VARS , $HTTP_POST_VARS , $HTTP_COOKIE_VARS ;
	global $xoopsDB ;

	if( $this->_done_dotdot ) return true ;
	else $this->_done_dotdot = true ;

	foreach( $_GET as $key => $val ) {
		if( is_array( $_GET[ $key ] ) ) continue ;
		if( preg_match( '?^[0-9a-z_./-]*\.\./[0-9a-z_./-]+$?i' , trim( $val ) ) ) {
			$this->last_error_type = 'ParentDir' ;
			$this->message .= "Doubtful file specification '$val' found.\n" ;
			if( empty( $conn ) ) $this->output_log( $this->last_error_type ) ;
			else $this->output_log_prepare( $this->last_error_type , $conn ) ;
			$sanitized_val = str_replace( '..' , '' , $val ) ;
			$_GET[ $key ] = $HTTP_GET_VARS[ $key ] = $sanitized_val ;
			if( $_REQUEST[ $key ] == $_GET[ $key ] ){
				$_REQUEST[ $key ] = $sanitized_val ;
			}
		}
	}
	foreach( $_POST as $key => $val ) {
		if( is_array( $_POST[ $key ] ) ) continue ;
		if( preg_match( '?^[0-9a-z_./-]*\.\./[0-9a-z_./-]+$?i' , trim( $val ) ) ) {
			$this->last_error_type = 'ParentDir' ;
			$this->message .= "Doubtful file specification '$val' found.\n" ;
			if( empty( $conn ) ) $this->output_log( $this->last_error_type ) ;
			else $this->output_log_prepare( $this->last_error_type , $conn ) ;
			$sanitized_val = str_replace( '..' , '' , $val ) ;
			$_POST[ $key ] = $HTTP_POST_VARS[ $key ] = $sanitized_val ;
			if( $_REQUEST[ $key ] == $_POST[ $key ] ){
				$_REQUEST[ $key ] = $sanitized_val ;
			}
		}
	}
	foreach( $_COOKIE as $key => $val ) {
		if( is_array( $_COOKIE[ $key ] ) ) continue ;
		if( preg_match( '?^[0-9a-z_./-]*\.\./[0-9a-z_./-]+$?i' , trim( $val ) ) ) {
			$this->last_error_type = 'ParentDir' ;
			$this->message .= "Doubtful file specification '$val' found.\n" ;
			if( empty( $conn ) ) $this->output_log( $this->last_error_type ) ;
			else $this->output_log_prepare( $this->last_error_type , $conn ) ;
			$sanitized_val = str_replace( '..' , '' , $val ) ;
			$_COOKIE[ $key ] = $HTTP_COOKIE_VARS[ $key ] = $sanitized_val ;
			if( $_REQUEST[ $key ] == $_COOKIE[ $key ] ){
				$_REQUEST[ $key ] = $sanitized_val ;
			}
		}
	}

	return true ;
}


function &get_ref_from_base64index( &$current , $indexes )
{
	foreach( $indexes as $index ) {
		$index = base64_decode( $index ) ;
		if( ! is_array( $current ) ) return false ;
		$current =& $current[ $index ] ;
	}
	return $current ;
}


function replace_doubtful( $key , $val )
{
	global $HTTP_GET_VARS , $HTTP_POST_VARS , $HTTP_COOKIE_VARS ;

	$index_expression = '' ;
	$indexes = explode( '_' , $key ) ;
	$base_array = array_shift( $indexes ) ;

	switch( $base_array ) {
		case 'G' :
			$main_ref =& $this->get_ref_from_base64index( $_GET , $indexes ) ;
			$legacy_ref =& $this->get_ref_from_base64index( $HTTP_GET_VARS , $indexes ) ;
			break ;
		case 'P' :
			$main_ref =& $this->get_ref_from_base64index( $_POST , $indexes ) ;
			$legacy_ref =& $this->get_ref_from_base64index( $HTTP_POST_VARS , $indexes ) ;
			break ;
		case 'C' :
			$main_ref =& $this->get_ref_from_base64index( $_COOKIE , $indexes ) ;
			$legacy_ref =& $this->get_ref_from_base64index( $HTTP_COOKIE_VARS , $indexes ) ;
			break ;
		default :
			exit ;
	}
	if( ! isset( $main_ref ) ) exit ;
	$request_ref =& $this->get_ref_from_base64index( $_REQUEST , $indexes ) ;
	if( $request_ref !== false && $main_ref == $request_ref ) {
		$request_ref = $val ;
	}
	$main_ref = $val ;
	$legacy_ref = $val ;
}


function check_uploaded_files()
{
	if( $this->_done_badext ) return $this->_safe_badext ;
	else $this->_done_badext = true ;

	$bad_pattern = "/(\.php|\.phtml|\.phtm|\.php3|\.php4|\.cgi|\.pl|\.asp)$/" ;
	foreach( $_FILES as $_file ) {
		if( ! empty( $_file['name'] ) && preg_match( $bad_pattern , $_file['name'] ) ) {
			$this->message .= "Attempt to upload {$_file['name']}.\n" ;
			$this->_safe_badext = false ;
			$this->last_error_type = 'UPLOAD' ;
		}
	}
	return $this->_safe_badext ;
}


function check_contami_systemglobals()
{
	if( $this->_done_contami ) return $this->_safe_contami ;
	else $this->_done_contami = true ;

	$bad_globals = array( 'GLOBALS' , '_SESSION' , 'HTTP_SESSION_VARS' , '_GET' , 'HTTP_GET_VARS' , '_POST' , 'HTTP_POST_VARS' , '_COOKIE' , 'HTTP_COOKIE_VARS' , '_SERVER' , 'HTTP_SERVER_VARS' , '_REQUEST' , '_ENV' , '_FILES' , 'xoopsDB' , 'xoopsUser' , 'xoopsUserId' , 'xoopsUserGroups' , 'xoopsUserIsAdmin' , 'xoopsConfig' , 'xoopsOption' , 'xoopsModule' , 'xoopsModuleConfig' ) ;
	foreach( $bad_globals as $bad_global ) {
		if( isset( $_REQUEST[ $bad_global ] ) ) {
			$this->message .= "Attempt to inject '$bad_global' was found.\n" ;
			$this->_safe_contami = false ;
			$this->last_error_type = 'CONTAMI' ;
		}
	}
	return $this->_safe_contami ;
}


function check_sql_isolatedcommentin( $sanitize = true )
{
	if( $this->_done_isocom ) return $this->_safe_isocom ;
	else $this->_done_isocom = true ;

	foreach( $this->_doubtful_requests as $key => $val ) {
		$str = $val ;
		while( $str = strstr( $str , '/*' ) ) { /* */
			$str = strstr( substr( $str , 2 ) , '*/' ) ;
			if( $str === false ) {
				$this->message .= "Isolated comment-in found. ($val)\n" ;
				if( $sanitize ) $this->replace_doubtful( $key , $val . '*/' ) ;
				$this->_safe_isocom = false ;
				$this->last_error_type = 'ISOCOM' ;
			}
		}
	}
	return $this->_safe_isocom ;
}


function check_sql_union( $sanitize = true )
{
	if( $this->_done_union ) return $this->_safe_union ;
	else $this->_done_union = true ;

	foreach( $this->_doubtful_requests as $key => $val ) {

		$str = str_replace( array( '/*' , '*/' ) , '' , preg_replace( '?/\*.+\*/?sU' , '' , $val ) ) ;
		if( preg_match( '/\sUNION\s+(ALL|SELECT)/i' , $str ) ) {
			$this->message .= "Pattern like SQL injection found. ($val)\n" ;
			if( $sanitize ) $this->replace_doubtful( $key , preg_replace( '/union/i' , 'uni-on' , $val ) ) ;
			$this->_safe_union = false ;
			$this->last_error_type = 'UNION' ;
		}
	}
	return $this->_safe_union ;
}


function check_dos_attack( $conf , $uid = 0 , $can_ban = false )
{
	global $xoopsDB ;

	if( $this->_done_dos ) return true ;

	$ip = $_SERVER['REMOTE_ADDR'] ;
	$uri = $_SERVER['REQUEST_URI'] ;
	$ip4sql = addslashes( $ip ) ;
	$uri4sql = addslashes( $uri ) ;
	if( empty( $ip ) || $ip == '' ) return true ;

	// gargage collection
	$result = $xoopsDB->queryF( "DELETE FROM ".$xoopsDB->prefix("protector_access")." WHERE expire < UNIX_TIMESTAMP()" ) ;

	// for older version before updated this module 
	if( $result === false ) {
		$this->_done_dos = true ;
		return true ;
	}

	// record access log
	$xoopsDB->queryF( "INSERT INTO ".$xoopsDB->prefix("protector_access")." SET ip='$ip4sql',request_uri='$uri4sql',expire=UNIX_TIMESTAMP()+'".intval($conf['dos_expire'])."'" ) ;

	// F5 attack check (High load & same URI)
	$result = $xoopsDB->query( "SELECT COUNT(*) FROM ".$xoopsDB->prefix("protector_access")." WHERE ip='$ip4sql' AND request_uri='$uri4sql'" ) ;
	list( $f5_count ) = $xoopsDB->fetchRow( $result ) ;
	if( $f5_count > $conf['dos_f5count'] ) {

		// extends the expires of the IP with 5 minutes at least
		$result = $xoopsDB->queryF( "UPDATE ".$xoopsDB->prefix("protector_access")." SET expire=UNIX_TIMESTAMP()+300 WHERE ip='$ip4sql' AND expire<UNIX_TIMESTAMP()+300" ) ;

		// actions for F5 Attack
		$this->_done_dos = true ;
		$this->last_error_type = 'DoS' ;
		switch( $conf['dos_f5action'] ) {
			case 'exit' :
				$this->output_log( $this->last_error_type , $uid , true ) ;
				exit ;
			case 'bip' :
				if( $can_ban ) $this->register_bad_ips() ;
				break ;
			case 'sleep' :
				sleep( $f5_count - $conf['dos_f5count'] ) ;
				break ;
		}
		return false ;
	}

	// Check its Agent
	if( preg_match( $conf['dos_crsafe'] , $_SERVER['HTTP_USER_AGENT'] ) ) {
		// welcomed crawler
		$this->_done_dos = true ;
		return true ;
	}

	// Crawler check (High load & different URI)
	$result = $xoopsDB->query( "SELECT COUNT(*) FROM ".$xoopsDB->prefix("protector_access")." WHERE ip='$ip4sql'" ) ;
	list( $crawler_count ) = $xoopsDB->fetchRow( $result ) ;
	if( $crawler_count > $conf['dos_crcount'] ) {

		// actions for bad Crawler
		$this->_done_dos = true ;
		$this->last_error_type = 'CRAWLER' ;
		switch( $conf['dos_craction'] ) {
			case 'exit' :
				$this->output_log( $this->last_error_type , $uid , true ) ;
				exit ;
			case 'bip' :
				if( $can_ban ) $this->register_bad_ips() ;
				break ;
			case 'sleep' :
				sleep( $crawler_count - $conf['dos_crcount'] ) ;
				break ;
		}
		return false ;
	}

	return true ;
}


function check_dos_attack_prepare( $conf , $conn )
{
	$ip = $_SERVER['REMOTE_ADDR'] ;
	$uri = $_SERVER['REQUEST_URI'] ;
	$ip4sql = addslashes( $ip ) ;
	$uri4sql = addslashes( $uri ) ;
	if( empty( $ip ) || $ip == '' ) return true ;

	$result = mysql_query( "DELETE FROM ".XOOPS_DB_PREFIX."_protector_access WHERE expire < UNIX_TIMESTAMP()" , $conn ) ;

	// for older version before updated this module 
	if( $result === false ) {
		$this->_done_dos = true ;
		return true ;
	}

	// record access log
	mysql_query( "INSERT INTO ".XOOPS_DB_PREFIX."_protector_access SET ip='$ip4sql',request_uri='$uri4sql',expire=UNIX_TIMESTAMP()+'".intval($conf['dos_expire'])."'" , $conn ) ;

	// F5 attack check (High load & same URI)
	$result = mysql_query( "SELECT COUNT(*) FROM ".XOOPS_DB_PREFIX."_protector_access WHERE ip='$ip4sql' AND request_uri='$uri4sql'" , $conn ) ;
	$f5_count = mysql_result( $result , 0 , 0 ) ;
	if( $f5_count > $conf['dos_f5count'] ) {

		// extends the expires of the IP with 5 minutes at least
		$result = mysql_query( "UPDATE ".XOOPS_DB_PREFIX."_protector_access SET expire=UNIX_TIMESTAMP()+300 WHERE ip='$ip4sql' AND expire<UNIX_TIMESTAMP()+300" , $conn ) ;

		// actions for F5 Attack
		$this->_done_dos = true ;
		$this->last_error_type = 'DoS' ;
		switch( $conf['dos_f5action'] ) {
			case 'exit' :
				$this->output_log_prepare( $this->last_error_type , $conn , true ) ;
				exit ;
			case 'bip' :
				sleep( 5 ) ; // only the lowest protection here
				$this->_should_be_banned = true ;
				break ;
			case 'sleep' :
				sleep( $f5_count - $conf['dos_f5count'] ) ;
				break ;
		}
		return false ;
	}

	// Check its Agent
	if( preg_match( $conf['dos_crsafe'] , $_SERVER['HTTP_USER_AGENT'] ) ) {
		// welcomed crawler
		$this->_done_dos = true ;
		return true ;
	}

	// Crawler check (High load & different URI)
	$result = mysql_query( "SELECT COUNT(*) FROM ".XOOPS_DB_PREFIX."_protector_access WHERE ip='$ip4sql'" , $conn ) ;
	$crawler_count = mysql_result( $result , 0 , 0 ) ;
	if( $crawler_count > $conf['dos_crcount'] ) {

		// actions for bad Crawler
		$this->_done_dos = true ;
		$this->last_error_type = 'CRAWLER' ;
		switch( $conf['dos_craction'] ) {
			case 'exit' :
				$this->output_log_prepare( $this->last_error_type , $conn , true ) ;
				exit ;
			case 'bip' :
				sleep( 5 ) ; // only the lowest protection here
				$this->_should_be_banned = true ;
				break ;
			case 'sleep' :
				sleep( $crawler_count - $conf['dos_crcount'] ) ;
				break ;
		}
		return false ;

	}

	$this->_done_dos = true ;
	return true ;
}


}
?>