<?php

function b_protector_show( $options )
{
	global $xoopsUser ;

	$block = array() ;

	// Protector class
	include_once( XOOPS_ROOT_PATH . '/modules/protector/class/protector.php' ) ;
	$protector =& Protector::getInstance() ;

	// Preferences (for performance, I dare to use an irregular method)
	$db =& Database::getInstance() ;
	$result = $db->query( "SELECT conf_name,conf_value FROM ".$db->prefix("config")." WHERE conf_title like '_MI_PROTECTOR%'" ) ;
	while( list( $key , $val ) = $db->fetchRow( $result ) ) {
		$conf[ $key ] = $val ;
	}

	// force intval variables whose name is *id
	if( $conf['id_forceintval'] ) $protector->intval_allrequestsendid() ;

	// eliminate '..' from requests looks like file specifications
	if( $conf['file_dotdot'] ) $protector->eliminate_dotdot() ;

	// user information (uid and can be banned)
	if( is_object( $xoopsUser ) ) {
		$uid = $xoopsUser->getVar('uid') ;
		$can_ban = count( array_intersect( $xoopsUser->getGroups() , unserialize( $conf['bip_except'] ) ) ) ? false : true ;
	} else {
		$uid = 0 ;
		$can_ban = true ;
	}

	// If precheck has already judged that he should be banned
	if( $can_ban && $protector->_should_be_banned ) {
		$protector->register_bad_ips() ;
	}

	// Variables contamination
	if( ! $protector->check_contami_systemglobals() ) {
		if( $conf['bip_contami'] && $can_ban ) $protector->register_bad_ips() ;
		$protector->output_log( 'CONTAMI' , $uid ) ;
		if( $conf['die_contami'] ) $protector->purge() ;
	}

	// SQL Injection "Isolated /*"
	if( ! $protector->check_sql_isolatedcommentin( $conf['san_isocom'] ) ) {
		if( $conf['bip_isocom'] && $can_ban ) $protector->register_bad_ips() ;
		$protector->output_log( 'ISOCOM' , $uid ) ;
		if( $conf['die_isocom'] ) $protector->purge() ;
	}

	// SQL Injection "UNION"
	if( ! $protector->check_sql_union( $conf['san_union'] ) ) {
		if( $conf['bip_union'] && $can_ban ) $protector->register_bad_ips() ;
		$protector->output_log( 'UNION' , $uid ) ;
		if( $conf['die_union'] ) $protector->purge() ;
	}

	// DoS Attack
	if( ! $protector->check_dos_attack( $conf , $uid , $can_ban ) ) {
		$protector->output_log( $protector->last_error_type , $uid , true ) ;
	}

	return $block ;
}


?>