<?php

function b_protector_show( $options )
{
	global $xoopsUser , $xoopsDB ;

	$block = array() ;

	// Protector class
	require_once( XOOPS_ROOT_PATH . '/modules/protector/class/protector.php' ) ;
	$protector =& Protector::getInstance( $xoopsDB->conn ) ;
	$conf = $protector->getConf() ;

	// global enabled or disabled
	if( ! empty( $conf['global_disabled'] ) ) return true ;

	// force intval variables whose name is *id
	if( $conf['id_forceintval'] ) $protector->intval_allrequestsendid() ;

	// eliminate '..' from requests looks like file specifications
	if( $conf['file_dotdot'] ) $protector->eliminate_dotdot() ;

	// user information (uid and can be banned)
	if( is_object( $xoopsUser ) ) {
		$uid = $xoopsUser->getVar('uid') ;
		$can_ban = count( array_intersect( $xoopsUser->getGroups() , unserialize( $conf['bip_except'] ) ) ) ? false : true ;
	} else {
		$uid = 0 ;
		$can_ban = true ;
	}

	// If precheck has already judged that he should be banned
	if( $can_ban && $protector->_should_be_banned ) {
		$protector->register_bad_ips() ;
	}

	// Variables contamination
	if( ! $protector->check_contami_systemglobals() ) {
		if( ( $conf['contami_action'] & 4 ) && $can_ban ) $protector->register_bad_ips() ;
		$protector->output_log( 'CONTAMI' , $uid , false ) ;
		if( $conf['contami_action'] & 2 ) $protector->purge() ;
	}

	// SQL Injection "Isolated /*"
	if( ! $protector->check_sql_isolatedcommentin( $conf['isocom_action'] & 1 ) ) {
		if( ( $conf['isocom_action'] & 4 ) && $can_ban ) $protector->register_bad_ips() ;
		$protector->output_log( 'ISOCOM' , $uid , 64 ) ;
		if( $conf['isocom_action'] & 2 ) $protector->purge() ;
	}

	// SQL Injection "UNION"
	if( ! $protector->check_sql_union( $conf['union_action'] & 1 ) ) {
		if( ( $conf['union_action'] & 4 ) && $can_ban ) $protector->register_bad_ips() ;
		$protector->output_log( 'UNION' , $uid , 64 ) ;
		if( $conf['union_action'] & 2 ) $protector->purge() ;
	}

	return $block ;
}


?>