<?php

// CONFIGURATIONS BEGIN

// cache life time for guests (default 3600sec=1hour)
define( 'FASTESTCACHE_EXPIRE_GUEST' , 3600 ) ;

// cache life time for users (default 300sec=5min)
define( 'FASTESTCACHE_EXPIRE_USER' , 300 ) ;

// gc executed with 1/DIVISOR probability when cache missed
define( 'FASTESTCACHE_GC_DIVISOR' , 300 ) ;

// a pattern for excluding some URIs (describe as perl regex)
define( 'FASTESTCACHE_EXCLUSION_REGEX' , '?(modules/contact)?' ) ;

// debug mode (you can see the hit ratio by counting fullcache/result)
define( 'FASTESTCACHE_DEBUG' , false ) ;

// CONFIGURATIONS END







if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;
if( empty( $_SERVER['REQUEST_URI'] ) ) return ;
if( preg_match( FASTESTCACHE_EXCLUSION_REGEX , $_SERVER['REQUEST_URI'] ) ) return ;

@ini_set( 'session.use_only_cookies' , 1 ) ;
@ini_set( 'session.use_trans_sid' , 0 ) ;

$fastestcache_sessionhash = empty( $_COOKIE['usersession'] ) ? '' : md5( @$_COOKIE[ $_COOKIE['usersession'] ] ) ;
 ;
$fastestcache_expire = empty( $fastestcache_sessionhash ) ? FASTESTCACHE_EXPIRE_GUEST : FASTESTCACHE_EXPIRE_USER ;

// for autologin hack
if( empty( $fastestcache_sessionhash ) && ! empty( $_COOKIE['autologin_pass'] ) ) {
	define( 'NOCACHE' , 1 ) ;
}

// disable if POST data exist or pagetype = 'user' or admin area
else if( ! empty( $_POST ) || @$xoopsOption['pagetype'] == 'user' || preg_match( '?(/system/|/admin/|register\.php)?' , $_SERVER['REQUEST_URI'] ) ) {
	define( 'NOCACHE' , 1 ) ;
}


$fastestcache_path = XOOPS_TRUST_PATH.'/fullcache/'.$fastestcache_sessionhash.'_'.md5( $_SERVER['REQUEST_URI'] ) ;


if( ! defined( 'NOCACHE' ) && @filemtime( $fastestcache_path ) > time() - $fastestcache_expire ) {
	// full cache hit
	if( isset( $easiestml_charset ) && strstr( EASIESTML_CHARSETS , $easiestml_charset ) ) {
		header( 'Content-Type: text/html; charset='.$easiestml_charset ) ;
	}
	header( 'Expires: Mon, 27 Jul 1997 05:00:00 GMT' ) ;
	header( 'Cache-Control: private, no-store' ) ;
	header( 'Pragma: no-cache' ) ;
	readfile( $fastestcache_path ) ;
	if( FASTESTCACHE_DEBUG ) error_log( "hit\n" , 3 , XOOPS_TRUST_PATH.'/fullcache/result' ) ;
	exit ;
} else {
	// full cache miss
	if( FASTESTCACHE_DEBUG ) error_log( "miss\n" , 3 , XOOPS_TRUST_PATH.'/fullcache/result' ) ;

	// garbage collection
	if( ( time() % FASTESTCACHE_GC_DIVISOR == 0 ) && $dh = opendir( XOOPS_TRUST_PATH.'/fullcache' ) ) {
		while( ( $fastestcache_file = readdir( $dh ) ) !== false ) {
			if( ! strstr( $fastestcache_file , '_' ) ) continue ;
			if( @filemtime( XOOPS_TRUST_PATH.'/fullcache/'.$fastestcache_file ) <= time() - FASTESTCACHE_EXPIRE_GUEST ) {
				@unlink( XOOPS_TRUST_PATH.'/fullcache/'.$fastestcache_file ) ;
			}
		}
		closedir( $dh ) ;
	}

	ob_start( 'fastestcache_storecache' ) ;
}



// storing contents into cache
function fastestcache_storecache( $s )
{
	if( defined( 'NOCACHE' ) ) return $s ;

	if( $s === '' ) return $s ;

	// caches are created only for HTML documents
	if( ! stristr( substr( $s , 0 , 100 ) , '<!DOCTYPE' ) ) {
		if( FASTESTCACHE_DEBUG ) error_log( "not html\n" , 3 , XOOPS_TRUST_PATH.'/fullcache/result' ) ;
		return $s ;
	}

	// removing session_id() from contents
	$s = str_replace( session_id() , '' , $s ) ;

	$fastestcache_sessionhash = is_object( $GLOBALS['xoopsUser'] ) ? md5( session_id() ) : '' ;
 ;

	// anti directory traversal
	$cache_file = str_replace( '..' , '' , $fastestcache_sessionhash . '_' . md5( $_SERVER['REQUEST_URI'] ) ) ;

	$fp = fopen( XOOPS_TRUST_PATH.'/fullcache/'.$cache_file , 'wb' ) ;
	fwrite( $fp , $s ) ;
	fclose( $fp ) ;
	return $s ;
}


function fastestcache_setcookie()
{
	// for logout
	if( @$_GET['op'] == 'logout' ) {
		fastestcache_clearcache() ;
		setcookie( 'usersession' , '' , time() - 3600 , $xoops_cookie_path ) ;
		return ;
	}

	// for redirect message
	if( ! empty( $_SESSION['redirect_message'] ) ) {
		define( 'NOCACHE' , 1 ) ;
	}

	$xoops_cookie_path = defined('XOOPS_COOKIE_PATH') ? XOOPS_COOKIE_PATH : preg_replace( '?http://[^/]+(/.*)$?' , "$1" , XOOPS_URL ) ;
	if( $xoops_cookie_path == XOOPS_URL ) $xoops_cookie_path = '/' ;

	// fastestcache
	if( is_object( $GLOBALS['xoopsUser'] ) ) {
		setcookie( 'usersession' , session_name() , 0 , $xoops_cookie_path ) ;
	} else {
		setcookie( 'usersession' , '' , time() - 3600 , $xoops_cookie_path ) ;
	}
}


// garbage collection for a user (called from redirect_header() normally)
function fastestcache_clearcache()
{
	//$fastestcache_mask = is_object( $GLOBALS['xoopsUser'] ) ? md5( session_id() ) . '_' : '_' ;

	// for login stage
	if( ! empty( $_POST['uname'] ) && ! empty( $_POST['uname'] ) ) {
		$xoops_cookie_path = defined('XOOPS_COOKIE_PATH') ? XOOPS_COOKIE_PATH : preg_replace( '?http://[^/]+(/.*)$?' , "$1" , XOOPS_URL ) ;
		if( $xoops_cookie_path == XOOPS_URL ) $xoops_cookie_path = '/' ;
		setcookie( 'usersession' , session_name() , 0 , $xoops_cookie_path ) ;
	}

	// guest cache will be never removed
	$fastestcache_mask = md5( session_id() ) . '_' ;

	$fastestcache_masklen = strlen( $fastestcache_mask ) ;
	if( $dh = opendir( XOOPS_TRUST_PATH.'/fullcache' ) ) {
		while( ( $fastestcache_file = readdir( $dh ) ) !== false ) {
			if( strncmp( $fastestcache_file , $fastestcache_mask , $fastestcache_masklen ) === 0 ) {
				@unlink( XOOPS_TRUST_PATH.'/fullcache/'.$fastestcache_file ) ;
			}
		}
		closedir( $dh ) ;
	}
}


?>